/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.menu.dropdown.components.settings;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.setting.Setting;
import Krasnodar.rockstarnew.ui.components.popup.Popup;
import Krasnodar.rockstarnew.ui.menu.dropdown.DropDownScreen;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.module.ModuleComponent;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import lombok.Generated;

public abstract class MenuSettingComponent<T extends Setting>
extends CustomComponent {
    private final CustomComponent parent;
    protected final T setting;
    private final Animation visibilityAnimation = new Animation(300L, Easing.BAKEK_PAGES);
    protected final Animation hoverAnimation = new Animation(300L, Easing.FIGMA_EASE_IN_OUT);

    public MenuSettingComponent(T setting, CustomComponent parent) {
        this.parent = parent;
        this.setting = setting;
    }

    @Override
    public void update(UIContext context) {
        ModuleComponent component;
        String translatedDescription = Localizator.translateOrEmpty(this.setting.getDescription());
        CustomComponent customComponent = this.parent;
        if (customComponent instanceof ModuleComponent && ((component = (ModuleComponent)customComponent).getParent().isHovered(context) && this.isHovered(context) || Rockstar.getInstance().getMenuScreen() instanceof DropDownScreen)) {
            ((DropDownScreen)Rockstar.getInstance().getMenuScreen()).setDesc(Localizator.translate(translatedDescription));
        }
        if (this.parent instanceof Popup && this.isHovered(context)) {
            Rockstar.getInstance().getHud().setDesc(Localizator.translate(translatedDescription));
        }
        super.update(context);
    }

    @Override
    public void onInit() {
        super.onInit();
    }

    public float getOpacity() {
        return this.visibilityAnimation.getValue();
    }

    public void drawRegular8(UIContext context) {
    }

    public void drawSplit(UIContext context) {
    }

    @Generated
    public CustomComponent getParent() {
        return this.parent;
    }

    @Generated
    public T getSetting() {
        return this.setting;
    }

    @Generated
    public Animation getVisibilityAnimation() {
        return this.visibilityAnimation;
    }

    @Generated
    public Animation getHoverAnimation() {
        return this.hoverAnimation;
    }
}

